<?php

class ToolController extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    public function __construct()
    {
        parent::__construct();
        if (!Csrf::isTokenValid()) {
          //redirect to forbidden and exit
          header('HTTP/1.0 403 Forbidden', true, 403);
          exit();
        }

        $this->user=Auth::isAuthenticated();
    }

    /**
     * Handles what happens when user moves to URL/index/index - or - as this is the default controller, also
     * when user moves to /index or enter your application at base level
     */
    public function index()
    {
        $role=RoleModel::getUserRole($this->user->{'cognito:username'});

        $vehicleid=Session::get('vehicleid');
        $this->View->render('admin/index', array(
            'permissions' => RoleModel::getPermissionsForRole($role),
            'vehicleid' => $vehicleid,
            'classes' => HmsModel::getAllVehicleClasses()
        ));
    }

    //public function inspection($id)
    public function inspection($id=null)
    {
        //$id=Validate::int(Request::post('id'));
        if(!isset($id))$id=Validate::int(Request::post('id'));

        $role=RoleModel::getUserRole($this->user->{'cognito:username'});

        $rolepermissions=RoleModel::getPermissionsForRole($role);
        $results=ToolModel::getInspectionRecord($id);
        $vehicleid=$results['vehicleid'];
        $vrn=$results['vrn'];


        $permissions=array();
        $permissions['addflaw']=json_encode($rolepermissions[$vehicleid."_Inspection_Add/Edit Flaw"]["granted"]);
        $permissions['addobservation']=json_encode($rolepermissions[$vehicleid."_Inspection_Add/Edit Observation"]["granted"]);
        $permissions['addsketch']=json_encode($rolepermissions[$vehicleid."_Inspection_Add/Edit Sketch"]["granted"]);
        $permissions['addphoto']=json_encode($rolepermissions[$vehicleid."_Inspection_Add/Edit Photo"]["granted"]);
        $permissions['editcomplete']=json_encode($rolepermissions[$vehicleid."_Inspection_Edit Complete"]["granted"]);

        $this->View->renderWithoutHeaderAndFooter('tool/inspection', array(
            'permissions' => $permissions,
            'vehicleid' => $vehicleid,
            'results' => $results,
            'vrn' => $vrn,
            'readonly' => 'false',
            'mode' => 'EDIT',
            'specificrepairschemes' => ToolModel::getSpecificRepairByVRN($vehicleid,$vrn)
        ));
    }

    public function viewInspection()
    {

        $id=Validate::int(Request::post('id'));

        $role=RoleModel::getUserRole($this->user->{'cognito:username'});

        $rolepermissions=RoleModel::getPermissionsForRole($role);
        $results=ToolModel::getInspectionRecord($id);
        $vehicleid=$results['vehicleid'];
        $vrn=$results['vrn'];


        $permissions=array();
        $permissions['addflaw']=json_encode($rolepermissions[$vehicleid."_Inspection_Add/Edit Flaw"]["granted"]);
        $permissions['addobservation']=json_encode($rolepermissions[$vehicleid."_Inspection_Add/Edit Observation"]["granted"]);
        $permissions['addsketch']=json_encode($rolepermissions[$vehicleid."_Inspection_Add/Edit Sketch"]["granted"]);
        $permissions['addphoto']=json_encode($rolepermissions[$vehicleid."_Inspection_Add/Edit Photo"]["granted"]);
        $permissions['editcomplete']=json_encode($rolepermissions[$vehicleid."_Inspection_Edit Complete"]["granted"]);
        $this->View->renderWithoutHeaderAndFooter('tool/inspection', array(
            'permissions' => $permissions,
            'vehicleid' => $vehicleid,
            'results' => $results,
            'vrn' => $vrn,
            'readonly' => 'true',
            'mode' => 'VIEW',
            'specificrepairschemes' => ToolModel::getSpecificRepairByVRN($vehicleid,$vrn)
        ));
    }

    public function createInspectionRecord()
    {
        $vehicleid=Session::get('vehicleid');
        $version=Validate::int(Request::post('version'));
        $unit=Validate::string(Request::post('unit'));
        $scheduleid=Validate::int(Request::post('schedule'));
        $vrn=Validate::string(Request::post('vrn'));
        $odometer=Validate::int(Request::post('odometer'));
        $id=ToolModel::createInspectionRecord($vehicleid,$version,$unit,$scheduleid,$vrn,$odometer);
        self::inspection($id);
    }

    public function getView()
    {
        $vehicleid=Session::get('vehicleid');
        $schedule=Validate::int(Request::post('scheduleid'));
        $type=Validate::string(Request::post('type'));
        $view=Validate::string(Request::post('view'));
        $version=Validate::int(Request::post('version'));
        $results=ToolModel::getInspectionView($vehicleid,$schedule,"inspection",$view,$version);
        echo $results;
    }

    public function saveInspectionRecord()
    {
        $recordid=Validate::string(Request::post('recordid'));
        $poddata=Validate::json(Request::post('poddata'));
        $date=Validate::date(Request::post('date'));
        $completed=Validate::int(Request::post('completed'));
        $overallstatus=Validate::int(Request::post('overallstatus'));
        $overallscore=Validate::float(Request::post('overallscore'));
        $results=ToolModel::saveInspectionRecord($recordid,$date,$poddata,$completed,$overallstatus,$overallscore);
        if($results)echo "The record was saved";
        else echo "There was an error saving the record";
    }

    public function deleteInspectionRecord()
    {
        $id=Validate::int(Request::post('id'));
        ToolModel::deleteInspectionRecord($id);
    }

    public function getInspectionReport()
    {
        $this->View->renderWithoutHeaderAndFooter('hms/pdf/inspection');
    }

    public function getVehicleCondition()
    {
        $vrn=Validate::int(Request::post('vrn'));
        ToolModel::getVehicleCondition($vrn);
        $this->View->renderWithoutHeaderAndFooter('tool/condition', array(
            'results' => ToolModel::getVehicleCondition($vrn)
        ));
    }

    public function getConditionReport()
    {
        $this->View->renderWithoutHeaderAndFooter('hms/pdf/conditionreport');
    }

    public function updateCondition()
    {
        $vehicleid=Session::get('vehicleid');
        $version=Validate::int(Request::post('version'));
        $vrn=Validate::string(Request::post('vrn'));
        $unit=Validate::string(Request::post('unit'));
        $overallscore=Validate::float(Request::post('overallscore'));
        $missionscore=Validate::float(Request::post('missionscore'));
        $safetyscore=Validate::float(Request::post('safetyscore'));
        $status=Validate::int(Request::post('status'));
        ToolModel::updateCondition($vehicleid,$version,$vrn,$unit,$overallscore,$missionscore,$safetyscore,$status);
    }

}


